/**
 * load the Essay (auto-grade) question
 *
 * @module      qtype_essayautograde/view
 * @category    output
 * @copyright   2018 Gordon Bateson (gordon.bateson@gmail.com)
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.0
 */
define("qtype_essayautograde/essayautograde",["jquery","core/str"],(function($,STR){var JS={plugin:"qtype_essayautograde",str:{},itemtype:"",itemsplit:"",minitems:0,maxitems:0,editortype:"",editormaxtries:50,editorinterval:100,responsesample:"",responseoriginal:"",init:function(readonly,itemtype,minitems,maxitems,editortype,responsesample){var itemsplit="";switch(itemtype){case"chars":itemsplit="";break;case"words":itemsplit="[\\s—–]+";break;case"sentences":itemsplit="[\\.?!]+";break;case"paragraphs":itemsplit="[\\r\\n]+"}JS.itemtype=itemtype,JS.itemsplit=new RegExp(itemsplit),JS.minitems=minitems,JS.maxitems=maxitems,JS.editortype=editortype,readonly?(JS.setup_read_only_files(),JS.setup_response_heights()):(JS.setup_itemcounts(),JS.setup_responsesample(responsesample))},setup_read_only_files:function(){STR.get_strings([{key:"rotate",component:JS.plugin},{key:"scale",component:JS.plugin},{key:"overflow",component:JS.plugin},{key:"auto",component:JS.plugin},{key:"hidden",component:JS.plugin},{key:"visible",component:JS.plugin},{key:"actions",component:"moodle"},{key:"crop",component:JS.plugin},{key:"reset",component:"moodle"},{key:"save",component:"moodle"}]).done((function(s){var i=0;JS.str.rotate=s[i++],JS.str.scale=s[i++],JS.str.overflow=s[i++],JS.str.auto=s[i++],JS.str.hidden=s[i++],JS.str.visible=s[i++],JS.str.actions=s[i++],JS.str.crop=s[i++],JS.str.reset=s[i++],JS.str.save=s[i++],document.querySelectorAll(".attachments .read-only-file.image .img-responsive").forEach((function(img){if(img.dataset.buttons_added)return!0;img.dataset.buttons_added=!0,img.classList.add("border-0"),img.classList.add("m-0"),img.classList.add("p-0");var container=document.createElement("DIV");container.classList.add("border-0"),container.classList.add("m-0"),container.classList.add("p-0"),container.classList.add("position-relative"),container.classList.add("image-container"),img.parentNode.insertBefore(container,img),container.appendChild(img),img.style.transitionDuration="1s",container.style.transitionDuration="1s",img.complete?JS.set_image_dimensions(img,container):img.onload=function(){JS.set_image_dimensions(this,this.parentNode)};var buttonsets=document.createElement("DIV");buttonsets.classList.add("border-0"),buttonsets.classList.add("m-0"),buttonsets.classList.add("p-0"),buttonsets.classList.add("buttonsets");var type="overflow",label=JS.str[type],buttonset=new Array,values=new Array("visible","auto","hidden");for(var i in values){var value=values[i],txt=JS.str[value],dataset={value:value};buttonset.push(JS.create_button(type,txt,dataset,JS.transform_image))}buttonsets.appendChild(JS.create_buttonset(type,label,buttonset));type="rotate",label=JS.str[type],buttonset=new Array,values=new Array(0,90,180,270);for(var i in values){txt=(value=values[i])+"°",dataset={value:value};buttonset.push(JS.create_button(type,txt,dataset,JS.transform_image))}buttonsets.appendChild(JS.create_buttonset(type,label,buttonset));type="scale",label=JS.str[type],buttonset=new Array,values=new Array(.5,1,1.5,2);for(var i in values){txt="×"+(value=values[i]),dataset={value:value};buttonset.push(JS.create_button(type,txt,dataset,JS.transform_image))}buttonsets.appendChild(JS.create_buttonset(type,label,buttonset)),container.parentNode.insertBefore(buttonsets,container.nextElementSibling)}))}))},set_image_dimensions:function(img,container){img.dataset.width=img.offsetWidth,img.dataset.height=img.offsetHeight,img.dataset.offset=img.offsetWidth-img.offsetHeight,img.dataset.ratio=img.offsetWidth/img.offsetHeight,container.dataset.width=container.offsetWidth,container.dataset.height=container.offsetHeight,container.style.height=container.dataset.height+"px",container.style.width=container.dataset.width+"px",img.style.position="absolute",img.setAttribute("draggable","true"),img.addEventListener("dragstart",JS.image_dragstart,!1),img.addEventListener("drag",JS.image_drag,!1),img.addEventListener("dragend",JS.image_dragend,!1)},image_dragstart:function(evt){this.style.transitionDuration="0s",this.dataset.evtPageY=evt.pageY,this.dataset.evtPageX=evt.pageX,this.dataset.imgOffsetTop=this.offsetTop,this.dataset.imgOffsetLeft=this.offsetLeft},image_drag:function(evt){if(evt.pageX&&evt.pageY){var offsetY=evt.pageY-this.dataset.evtPageY,offsetX=evt.pageX-this.dataset.evtPageX,offsetTop=parseInt(this.dataset.imgOffsetTop),offsetLeft=parseInt(this.dataset.imgOffsetLeft);this.style.top=offsetTop+offsetY+"px",this.style.left=offsetLeft+offsetX+"px"}},image_dragend:function(evt){return this.style.transitionDuration="1s",evt.preventDefault&&evt.preventDefault(),evt.stopPropagation&&evt.stopPropagation(),!1},create_buttonset:function(type,txt,buttons){var buttonset=document.createElement("DIV");if(buttonset.classList.add("bg-secondary"),buttonset.classList.add("rounded"),buttonset.classList.add("mt-1"),buttonset.classList.add("pl-1"),buttonset.classList.add("buttonset"),type&&buttonset.classList.add(type+"-buttonset"),txt){var span=document.createElement("SPAN");span.classList.add("font-weight-bold"),span.appendChild(document.createTextNode(txt+":")),buttonset.appendChild(span)}if(buttons)for(var i in buttons)buttonset.appendChild(buttons[i]);return buttonset},create_button:function(type,txt,dataset,fn){var button=document.createElement("BUTTON");if(button.setAttribute("type","button"),button.classList.add("button"),button.classList.add("button-light"),button.classList.add("border"),button.classList.add("rounded"),button.classList.add("my-1"),button.classList.add("ml-1"),button.classList.add("mr-0"),button.classList.add("px-2"),type&&button.classList.add(type+"-button"),txt&&button.appendChild(document.createTextNode(txt)),dataset)for(var name in dataset)button.dataset[name]=dataset[name];return fn&&button.addEventListener("click",fn,!1),button},transform_image:function(){var buttonset=this.parentNode;if(!buttonset.matches(".buttonset"))return!1;buttonset.querySelectorAll(".btn-info").forEach((function(button){JS.deselect_button(button)})),JS.select_button(this);var buttonsets=buttonset.parentNode;if(!buttonsets.matches(".buttonsets"))return!1;var container=buttonsets.previousElementSibling;if(!container.matches(".image-container"))return!1;var img=container.querySelector("img");if(!img)return!1;var reset="reset"==this.dataset.value,overflow="visible";(button=buttonsets.querySelector(".overflow-buttonset .btn-info"))&&(reset&&(button=JS.set_default_button(button,"overflow",overflow)),overflow=button.dataset.value);var rotate_angle=0;(button=buttonsets.querySelector(".rotate-buttonset .btn-info"))&&(reset&&(button=JS.set_default_button(button,"rotate",rotate_angle)),rotate_angle=button.dataset.value);var button,scale_factor=1;(button=buttonsets.querySelector(".scale-buttonset .btn-info"))&&(reset&&(button=JS.set_default_button(button,"scale",scale_factor)),scale_factor=button.dataset.value);var t=img.style.transform;if(t=t.replace(new RegExp(" *(rotate|scale|translate) *\\([^)]*\\)","g"),""),rotate_angle&&(t+=" rotate("+rotate_angle+"deg)"),90==rotate_angle||270==rotate_angle){"visible"==overflow&&(scale_factor*=img.dataset.ratio);var offset=img.dataset.offset*scale_factor;270==rotate_angle&&(offset=-offset),t+=" translate("+offset/2+"px, "+offset/2+"px)"}img.style.transform=t.trim(),img.style.maxWidth="initial",img.style.width=img.dataset.width*scale_factor+"px";var h=0;h=90==rotate_angle||270==rotate_angle?container.dataset.width:container.dataset.height,("visible"==overflow||scale_factor<1)&&(h*=scale_factor),container.style.overflow=overflow,container.style.height=h+"px",reset&&JS.deselect_button(this)},select_button:function(button){button.classList.remove("btn-light"),button.classList.add("btn-info")},deselect_button:function(button){button.classList.remove("btn-info"),button.classList.add("btn-light")},set_default_button:function(button,type,value){return button.dataset.value==value||(JS.deselect_button(button),(button=button.parentNode.querySelector("."+type+'-button[data-value="'+value+'"]'))&&(button.classList.remove("btn-light"),button.classList.add("btn-info"))),button},setup_response_heights:function(){$("textarea.qtype_essay_response").each((function(){$(this).height(1),$(this).height(this.scrollHeight)}))},setup_itemcounts:function(){STR.get_strings([{key:"maxwordswarning",component:JS.plugin},{key:"minwordswarning",component:JS.plugin}]).done((function(s){var i=0;JS.str.maxwordswarning=s[i++],JS.str.minwordswarning=s[i++],$(".qtype_essay_response").each((function(){var id=JS.get_itemcount_id(this),editorloaded=$.Deferred();JS.check_editor(this,editorloaded),$.when(editorloaded).done($.proxy((function(){JS.setup_itemcount(this,id)}),this,id))}))}))},check_editor:function(response,editorloaded){var selector="";switch(JS.editortype){case"atto":selector="[contenteditable=true]";break;case"tinymce":selector="iframe"}if(""==selector)editorloaded.resolve();else var editorchecker=setInterval((function(){$(response).find(selector).length&&(clearInterval(editorchecker),editorloaded.resolve())}),JS.editorinterval)},setup_itemcount:function(response,id){var editable=JS.get_editable_element(response);editable&&($(editable).keyup((function(){JS.show_itemcount(this,id)})),JS.show_itemcount(editable,id))},get_editable_element:function(response){if("TEXTAREA"==$(response).prop("tagName"))return response;if((editable=$(response).find("[contenteditable=true]")).length)return editable.get(0);var editable,i=response.getElementsByTagName("IFRAME");if(i.length){var d=(i=i[0]).contentWindow||i.contentDocument;if(d.document&&(d=d.document),d.body&&d.body.isContentEditable)return d.body}return(editable=$(response).find("textarea")).length?editable.get(0):null},get_textarea:function(response){return"TEXTAREA"==$(response).prop("tagName")?response:$(response).find("textarea").get(0)},get_textarea_name:function(response){var textarea=JS.get_textarea(response);return $(textarea).attr("name")},get_itemcount_id:function(response){return"id_"+JS.get_textarea_name(response)+"_itemcount"},escaped_id:function(id){var regexp=new RegExp("(:|\\.|\\[|\\]|,|=|@)","g");return"#"+id.replace(regexp,"\\$1")},show_itemcount:function(response,id){var itemcount=("TEXTAREA"==$(response).prop("tagName")?$(response).val():$(response).text()).split(JS.itemsplit).filter((function(item){return""!==item})).length;if(id=JS.escaped_id(id),$(id+" .countitems .value").text(itemcount),"words"==JS.itemtype){var warningtext="";itemcount&&(JS.minitems&&JS.minitems>itemcount&&(warningtext=JS.str["min"+JS.itemtype+"warning"]),JS.maxitems&&JS.maxitems<itemcount&&(warningtext=JS.str["max"+JS.itemtype+"warning"]));var elm=document.querySelector(id+" .countitems .warning");elm&&(elm.innerText=warningtext,""==warningtext?elm.classList.add("d-none"):elm.classList.remove("d-none"))}},setup_responsesample:function(txt){""!=txt&&(JS.responsesample=txt,STR.get_strings([{key:"hidesample",component:JS.plugin},{key:"showsample",component:JS.plugin}]).done((function(s){var i=0;JS.str.hidesample=s[i++],JS.str.showsample=s[i++];var last=$(".qtext").find("p:not(:empty), div:not(:empty)");(last=last.length?last.last():$(".qtext")).append($("<span></span>").click((function(){var newtxt="",oldtxt="",saveresponse=!1;$(this).hasClass("showsample")?($(this).removeClass("showsample").addClass("hidesample").text(JS.str.hidesample),newtxt=JS.responsesample,saveresponse=!0):($(this).removeClass("hidesample").addClass("showsample").text(JS.str.showsample),newtxt=JS.responseoriginal);var editor=null,qtext=$(this).closest(".qtext");if("audio"==JS.editortype||"video"==JS.editortype)editor=qtext.find(".audiovideo_response_prompt");else{var r=qtext.next(".ablock").find(".answer .qtype_essay_response");r.is("[name$='_answer']")?editor=r:0==(editor=r.find("[contenteditable=true]")).length&&0==(editor=r.find("iframe").contents().find("[contenteditable=true]")).length&&(editor=r.find("[name$='_answer']"))}return null!==editor&&0!=editor.length&&("TEXTAREA"==editor.prop("tagName")?(oldtxt=editor.val(),editor.val(newtxt).keyup()):(oldtxt=editor.text(),editor.text(newtxt).keyup()),saveresponse&&(JS.responseoriginal=oldtxt),!0)})).trigger("click"))})))}};return JS}));

//# sourceMappingURL=essayautograde.min.js.map